<?php
/**
 * BeA Custom Theme functions and definitions
 *
 * @package BeA Custom Theme
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */

define('WOOCOMMERCE_USE_CSS', false);


if ( ! isset( $content_width ) )
	$content_width = 640; /* pixels */

if ( ! function_exists( 'bea_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */





//add_action( 'pre_get_posts', 'custom_pre_get_posts_query' );

function custom_pre_get_posts_query( $q )

{
global $new, $url;

 $new = '/product-category/tools/stapler/';
 $url = $_SERVER['REQUEST_URI'];


//    if (!isset($_GET['my_nonce']) || !wp_verify_nonce($_GET['my_nonce'], 'doing_something')) {
//if (!$q->is_main_query() and  !is_shop()) return;
if (!$q->is_main_query()) return;
if ( ! is_admin() & $url == $new)
{
$q->set( 'tax_query', array(array(
'taxonomy' => 'product_cat',
'field' => 'id',
'terms' => array( 483, 406, 468, 421, 401, 404, 325, 327, 482 ),
'operator' => 'NOT IN'
)));

}
}







function bea_setup() {


	/**
	 * Make theme available for translation
	 * Translations can be filed in the /languages/ directory
	 * If you're building a theme based on BeA Custom Theme, use a find and replace
	 * to change 'bea' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'bea', get_template_directory() . '/languages' );

	/**
	 * Add default posts and comments RSS feed links to head
	 */
	add_theme_support( 'automatic-feed-links' );

	/**
	 * Enable support for Post Thumbnails on posts and pages
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	//add_theme_support( 'post-thumbnails' );

	/**
	 * This theme uses wp_nav_menu() in one location.
	 */
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'bea' ),
	) );

	/**
	 * Enable support for Post Formats
	 */
	add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link' ) );
}
endif; // bea_setup
add_action( 'after_setup_theme', 'bea_setup' );

/**
 * Setup the WordPress core custom background feature.
 *
 * Use add_theme_support to register support for WordPress 3.4+
 * as well as provide backward compatibility for WordPress 3.3
 * using feature detection of wp_get_theme() which was introduced
 * in WordPress 3.4.
 *
 * @todo Remove the 3.3 support when WordPress 3.6 is released.
 *
 * Hooks into the after_setup_theme action.
 */
function bea_register_custom_background() {
	$args = array(
		'default-color' => 'ffffff',
		'default-image' => '',
	);

	$args = apply_filters( 'bea_custom_background_args', $args );

	if ( function_exists( 'wp_get_theme' ) ) {
		add_theme_support( 'custom-background', $args );
	} else {
		define( 'BACKGROUND_COLOR', $args['default-color'] );
		if ( ! empty( $args['default-image'] ) )
			define( 'BACKGROUND_IMAGE', $args['default-image'] );
		add_custom_background();
	}
}
add_action( 'after_setup_theme', 'bea_register_custom_background' );

/**
 * Register widgetized area and update sidebar with default widgets
 */
function bea_widgets_init() {


	register_sidebar( array(
		'name'          => __( 'Sidebar', 'bea' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="usfilter widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );



	register_sidebar( array(
		'name'          => __( 'Metric Filter', 'besa' ),
		'id'            => 'sidebar-2',
		'before_widget' => '<aside id="%1$s" class="metricfilter widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );

}




add_action( 'widgets_init', 'bea_widgets_init' );









function get_attachment_url_by_slug( $slug ) {
  $args = array(
    'post_type' => 'attachment',
    'name' => sanitize_title($slug),
    'posts_per_page' => 1,
    'post_status' => 'inherit',
  );
  $_header = get_posts( $args );
  $header = $_header ? array_pop($_header) : null;
  return $header ? wp_get_attachment_url($header->ID) : '';
}












add_filter( 'loop_shop_per_page', create_function( '$cols', 'return -1;' ), 20 );












add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );


/**
 * Enqueue scripts and styles
 */
function bea_scripts() {



		wp_enqueue_script( 'jquery-2.1.1', get_template_directory_uri() . '/js/jquery-2.1.1.js', array(), '20140915', true );
		wp_enqueue_script( 'jquery.cookie', get_template_directory_uri() . '/js/jquery.cookie.js', array(), '20140915', true );

	//wp_enqueue_script("jquery");

		//wp_enqueue_script( 'metric-us', get_template_directory_uri() . '/js/metric-us.js', array(), '20140915', true );
        //wp_enqueue_script( 'us-metric', get_template_directory_uri() . '/js/us-metric.js', array(), '20140915', true );


        wp_enqueue_script( 'metric-us-lib', get_template_directory_uri() . '/js/metric-us-lib.js', array(), '20140915', true );
		//wp_enqueue_script( 'measure-switch', get_template_directory_uri() . '/js/measure-switch.js', array(), '20140915', true );







		wp_enqueue_style( 'queries-css', get_stylesheet_directory_uri() . '/css/queries.css' );



		wp_enqueue_style( 'BeA Custom Theme-style', get_stylesheet_uri() );

		wp_enqueue_script( 'BeA Custom Theme-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );

		wp_enqueue_script( 'BeA Custom scripts', get_template_directory_uri() . '/js/custom.js', array(), '20120206', true );

		wp_enqueue_script( 'BeA Custom Theme-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );








	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	if ( is_singular() && wp_attachment_is_image() ) {
		wp_enqueue_script( 'BeA Custom Theme-keyboard-image-navigation', get_template_directory_uri() . '/js/keyboard-image-navigation.js', array( 'jquery' ), '20120202' );
	}
}
add_action( 'wp_enqueue_scripts', 'bea_scripts' );

/**
 * Implement the Custom Header feature.
 */
//require( get_template_directory() . '/inc/custom-header.php' );

/**
 * Custom template tags for this theme.
 */
require( get_template_directory() . '/inc/template-tags.php' );

/**
 * Custom functions that act independently of the theme templates.
 */
require( get_template_directory() . '/inc/extras.php' );

/**
 * Customizer additions.
 */
require( get_template_directory() . '/inc/customizer.php' );

/**
 * Load Jetpack compatibility file.
 */
require( get_template_directory() . '/inc/jetpack.php' );

add_action( 'wp_enqueue_scripts', 'custom_frontend_scripts' );

function custom_frontend_scripts() {

  	global $post, $woocommerce;

	//	$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
	//	wp_deregister_script( 'jquery-cookie' );
	//	wp_register_script( 'jquery-cookie', $woocommerce->plugin_url() . '/assets/js/jquery-cookie/jquery.cookie' . $suffix . '.js', array( 'jquery' ), '1.4.0', true );


}

function woocommerce_remove_related_products(){
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
}
add_action('woocommerce_after_single_product_summary', 'woocommerce_remove_related_products');

//remove_action( 'woocommerce_pagination', 'woocommerce_catalog_ordering', 20 );

//Remove Sidebar from WooCommerce
//remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);

/*
* goes in theme functions.php or a custom plugin. Replace the image filename/path with your own :)
*
**/
add_action( 'init', 'custom_fix_thumbnail' );

function custom_fix_thumbnail() {

	add_filter('woocommerce_placeholder_img_src', 'custom_woocommerce_placeholder_img_src');

	function custom_woocommerce_placeholder_img_src( $src ) {
		$upload_dir = wp_upload_dir();
		$uploads = untrailingslashit( $upload_dir['baseurl'] );
		$src = $uploads . '/2013/06/comingSoon.jpg';
		return $src;
	}
}



function wc_origin_trail_ancestor( $link = false, $trail = false ) {

    if (is_product_category()) {
        global $wp_query;
        $q_obj = $wp_query->get_queried_object();
        $cat_id = $q_obj->term_id;

        $descendant = get_term_by("id", $cat_id, "product_cat");
        $descendant_id = $descendant->term_id;

        $ancestors = get_ancestors($cat_id, 'product_cat');
        $ancestors = array_reverse($ancestors);

        $origin_ancestor = get_term_by("id", $ancestors[0], "product_cat");
        $origin_ancestor_id = $origin_ancestor->term_id;

        $ac = count($ancestors);

    } else if ( is_product() ) {

        $descendant = get_the_terms( $post->ID, 'product_cat' );
        $descendant = array_reverse($descendant);
        $descendant = $descendant[0];
        $descendant_id = $descendant->term_id;

        $ancestors = array_reverse(get_ancestors($descendant_id, 'product_cat'));
        $ac = count($ancestors);

    }


    $c = 1;
    if( $trail == false ){

        $origin_ancestor_term = get_term_by("id", $ancestors[0], "product_cat");
        $origin_ancestor_link = get_term_link( $origin_ancestor_term->slug, $origin_ancestor_term->taxonomy );

        if($link == true)
            echo '<a href="'. $origin_ancestor_link .'">';
        echo $origin_ancestor_term->name;
        if($link == true)
            echo '</a>';

    }else{

        foreach ($ancestors as $ancestor) {
            $ancestor_term = get_term_by("id", $ancestor, "product_cat");
            $ancestor_link = get_term_link( $ancestor_term->slug, $ancestor_term->taxonomy );

            if($c++ == 1)
                echo '» ';
            else if($c++ != 1 || $c++ != $ac)
                echo ' » ';

            if($link == true)
                echo '<a href="'. $ancestor_link .'">';
            echo  $ancestor_term->name;
            if($link == true)
                echo '</a>';

        }

        $descendant_term = get_term_by("id", $descendant_id, "product_cat");
        $descendant_link = get_term_link( $descendant_term->slug, $descendant_term->taxonomy );

        echo ' » ';
        if($link == true)
            echo '<a href="'. $descendant_link .'">';
        echo $descendant->name;
        if($link == true)
            echo '</a>';

    }

}


//NUMBER OF PRODICTS TO DISPLAY ON SHOP PAGE



/*
Plugin Name: WooCommerce Attribute Links
Description: Display product attribute archive links on product page, right below the add to cart button.
Version: 1.0
Author: Coen Jacobs
Author URI: http://coenjacobs.me
*/




//add_action( 'woocommerce_product_meta_end', 'cj_show_attribute_links' );
//
//function cj_show_attribute_links() {
//	global $post;
//	$attribute_names = array( 'pa_fastener' ); // Insert attribute names here
//
//	foreach ( $attribute_names as $attribute_name ) {
//		$taxonomy = get_taxonomy( $attribute_name );
//
//		if ( $taxonomy && ! is_wp_error( $taxonomy ) ) {
//			$terms = wp_get_post_terms( $post->ID, $attribute_name );
//			$terms_array = array();
//
//	        if ( ! empty( $terms ) ) {
//		        foreach ( $terms as $term ) {
//		        $archive_link = get_term( $term->slug, $attribute_name );
//		    	//
//		$term_list = wp_get_post_terms($post->ID,'product_cat',array('fields'=>'ids'));
//		$cat_id = (int)$term_list[0];
//		$newlink = get_term_link ($cat_id, 'product_cat');
//
//			      //original
//					//$archive_link = get_term_link( $term->slug, $attribute_name );
//			      	//  $full_line = '<a href="' . $archive_link . '">'. $term->name . '</a>';
//
//
//				$full_line = '<a href="' . $newlink . '">'. $term->name . '</a>';
//
//
//			       array_push( $terms_array, $full_line );
//		        }
//
//		        echo $taxonomy->labels->name . ' ' . implode( $terms_array, ', ' );
//	        }
//  	}
//    }
//}

add_action( 'woocommerce_product_meta_end', 'cj_show_attribute_links_2' );

function cj_show_attribute_links_2() {
	global $post;
	$attribute_names = array( 'pa_fastener' ); // Insert attribute names here

	foreach ( $attribute_names as $attribute_name ) {
		$taxonomy = get_taxonomy( $attribute_name );

		if ( $taxonomy && ! is_wp_error( $taxonomy ) ) {
			$terms = wp_get_post_terms( $post->ID, $attribute_name );
			$terms_array = array();

	        if ( ! empty( $terms ) ) {
		        foreach ( $terms as $term ) {
		        $archive_link = get_term( $term->slug, $attribute_name );
		    	//
		        $term_list = wp_get_post_terms($post->ID,'pa_fastener',array('fields'=>'ids'));
		        $fastener_id = (int)$term_list[0];
		        $newlink = get_term_link ($fastener_id, 'pa_fastener');

			      //original
					//$archive_link = get_term_link( $term->slug, $attribute_name );
			      	//  $full_line = '<a href="' . $archive_link . '">'. $term->name . '</a>';


				//$full_line = '<a href="' . $newlink . '">' . $term->name . '</a>';
                //echo $fastener_id;
                    $full_line = '<a href="/product-category/tools/?filtering=1&filter_fastener=' . $fastener_id . '">: ' . $term->name . '</a>';

			       array_push( $terms_array, $full_line );
		        }

		        echo $taxonomy->labels->name . ' ' . implode( $terms_array, ', ' );
	        }
    	}
    }
}


//add_action( 'cj_show_attribute_links_3' );

function cj_show_attribute_links_3() {
	global $post;
	$attribute_names = array( 'pa_fastener' ); // Insert attribute names here

	foreach ( $attribute_names as $attribute_name ) {
		$taxonomy = get_taxonomy( $attribute_name );

		if ( $taxonomy && ! is_wp_error( $taxonomy ) ) {
			$terms = wp_get_post_terms( $post->ID, $attribute_name );
			$terms_array = array();

	        if ( ! empty( $terms ) ) {
		        foreach ( $terms as $term ) {
		        $archive_link = get_term( $term->slug, $attribute_name );
		    	//
		        $term_list = wp_get_post_terms($post->ID,'pa_fastener',array('fields'=>'ids'));
		        $fastener_id = (int)$term_list[0];
		        $newlink = get_term_link ($fastener_id, 'pa_fastener');

			      //original
					//$archive_link = get_term_link( $term->slug, $attribute_name );
			      	//  $full_line = '<a href="' . $archive_link . '">'. $term->name . '</a>';


				//$full_line = '<a href="' . $newlink . '">' . $term->name . '</a>';
                //echo $fastener_id;
                    $full_line = '<a href="/product-category/fasteners/?filtering=1&filter_fastener=' . $fastener_id . '">' . $term->name . '</a>';

			       array_push( $terms_array, $full_line );
		        }

		        echo $taxonomy->labels->name . ' ' . implode( $terms_array, ', ' );
	        }
    	}
    }
}


 function get_category_id($category_name){
    $term = get_term_by('slug', $category_name, 'product_cat');
    return $term->term_id;

   // $terms = get_term_children( $directoryId, 'ad_cat' );





}





// LOAD PRETTY PHOTO for the whole site
add_action( 'wp_enqueue_scripts', 'frontend_scripts_include_lightbox' );
function frontend_scripts_include_lightbox() {
  global $woocommerce;
  $suffix      = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
  $lightbox_en = get_option( 'woocommerce_enable_lightbox' ) == 'yes' ? true : false;
  if ( $lightbox_en ) {
    wp_enqueue_script( 'prettyPhoto', $woocommerce->plugin_url() . '/assets/js/prettyPhoto/jquery.prettyPhoto' . $suffix . '.js', array( 'jquery' ), $woocommerce->version, true );
    wp_enqueue_script( 'prettyPhoto-init', $woocommerce->plugin_url() . '/assets/js/prettyPhoto/jquery.prettyPhoto.init' . $suffix . '.js', array( 'jquery' ), $woocommerce->version, true );
    wp_enqueue_style( 'woocommerce_prettyPhoto_css', $woocommerce->plugin_url() . '/assets/css/prettyPhoto.css' );

  }
}

/* add rel prettyphoto to all images */
function autoadd_rel_prettyPhoto($content) {
 global $post;
 $pattern = "/(<a(?![^>]*?data-rel=['\"]prettyPhoto.*)[^>]*?href=['\"][^'\"]+?\.(?:bmp|gif|jpg|jpeg|png|html)['\"][^\>]*)>/i";
 $replacement = '$1 data-rel="prettyPhoto['.$post->ID.']">';
 $content = preg_replace($pattern, $replacement, $content);
 return $content;
}
add_filter("the_content","autoadd_rel_prettyPhoto");







function woocommerce_subcats_from_parentcat_by_NAME($parent_cat_NAME) {
  $IDbyNAME = get_term_by('name', $parent_cat_NAME, 'product_cat');
  $product_cat_ID = $IDbyNAME->term_id;
    $args = array(
       'hierarchical' => 1,
       'show_option_none' => '',
       'hide_empty' => 0,
       'parent' => $product_cat_ID,
       'taxonomy' => 'product_cat'
    );
  $subcats = get_categories($args);
    echo '<ul class="wooc_sclist">';
      foreach ($subcats as $sc) {
        $link = get_term_link( $sc->slug, $sc->taxonomy );
          echo '<li><a href="'. $link .'">'.$sc->name.'</a></li>';
      }
    echo '</ul>';
}






add_filter( 'woocommerce_product_tabs', 'wcs_woo_remove_reviews_tab', 98 );
function wcs_woo_remove_reviews_tab($tabs) {
 unset($tabs['reviews']);
 return $tabs;
}



/**
 * Custom woocommerce integration start
 */

add_action( 'after_setup_theme', 'woocommerce_support' );
function woocommerce_support() {
    add_theme_support( 'woocommerce' );
}

/**
 * Custom woocommerce integration end
 */



