<?php
class BeRocket_new_AAPF_Widget extends WP_Widget 
{
    public function __construct() {
        parent::__construct("berocket_aapf_group", "AAPF Filters Group",
            array("description" => "AJAX Product Filters Group"));
    }
    public function widget($args, $instance) {
        $show_filters = true;
        if( empty($instance['group_id']) ) {
            return false;
        }
        $filters = get_post_meta( $instance['group_id'], 'br_filter_group', true );
        if( empty($filters) ) {
            return false;
        }
        if( ! empty($filters['data']) && ! $this->check_group_on_page($filters['data']) ) {
            return false;
        }
        global $wp_registered_sidebars;
        $is_shortcode = empty($args['id']) || ! isset($wp_registered_sidebars[$args['id']]);
        $new_args = $args;
        if( ! $is_shortcode ) {
            $sidebar = $wp_registered_sidebars[$args['id']];
            $new_args = array_merge($new_args, $sidebar);
            $before_widget = $new_args['before_widget'];
        }
        $i = 1;
        ob_start();
        foreach($filters['filters'] as $filter) {
            if( $is_shortcode ) {
                if( isset($new_args['before_widget']) ) {
                    unset($new_args['before_widget']);
                }
                if( isset($new_args['after_widget']) ) {
                    unset($new_args['after_widget']);
                }
            } else {
                $new_args['widget_id'] = $args['widget_id'].'-'.$i;
                $new_args['before_widget'] = sprintf($before_widget, $new_args['widget_id'], '%s');
            }
            the_widget( 'BeRocket_new_AAPF_Widget_single', array('filter_id' => $filter), $new_args);
            $i++;
        }
        $widget_html = ob_get_clean();
        if( ! empty($widget_html) ) {
            echo $widget_html;
        } else {
            return false;
        }
    }
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['group_id'] = strip_tags( @ $new_instance['group_id'] );
        return $instance;
    }
    public function form($instance) {
        $instance = wp_parse_args( (array) $instance, array( 'group_id' => '') );
        echo '<a href="' . admin_url('edit.php?post_type=br_filters_group') . '">' . __('Manage groups', 'BeRocket_AJAX_domain') . '</a>';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('group_id'); ?>"><?php _e('Group', 'BeRocket_AJAX_domain'); ?></label>
            <?php
            $query = new WP_Query(array('post_type' => 'br_filters_group', 'nopaging' => true));
            if ( $query->have_posts() ) {
                echo '<select id="'.$this->get_field_id('group_id').'" name="'.$this->get_field_name('group_id').'">';
                while ( $query->have_posts() ) {
                    if( empty($instance['group_id']) ) {
                        $instance['group_id'] = get_the_id();
                    }
                    $query->the_post();
                    echo '<option value="' . get_the_id() . '"'.(get_the_id() == $instance['group_id'] ? ' selected' : '').'>' . get_the_title() . ' (ID:' . get_the_id() . ')</option>';
                }
                echo '</select>';
                wp_reset_postdata();
            }
            ?>
        </p>
        <?php
    }
    public function check_group_on_page($filters_data, $wp_query_in = false, $page_in = false) {
        if( $wp_query_in === false ) {
            global $wp_the_query;
            $wp_query_in = $wp_the_query;
        }
        if( $page_in === false ) {
            global $page;
            $page_in = $page;
        }
        $show_filters = false;
        foreach($filters_data as $filters) {
            $show_filters = false;
            foreach($filters as $condition) {
                $show_filters = apply_filters('berocket_filters_condition_check_type_' . $condition['type'], false, $condition, $wp_query_in, $page_in);
                if( !$show_filters ) {
                    break;
                }
            }
            if( $show_filters ) {
                break;
            }
        }
        return $show_filters;
    }
}
class BeRocket_new_AAPF_Widget_single extends WP_Widget 
{
    public function __construct() {
        parent::__construct("berocket_aapf_single", "AAPF Filter Single",
            array("description" => "AJAX Product Filters Single"));
    }
    public function widget($args, $instance) {
        $show_filters = true;
        if( empty($instance['filter_id']) ) {
            return false;
        }
        $filter_id = $instance['filter_id'];
        $filter_post = get_post($filter_id);
        $filter_data = get_post_meta( $filter_id, 'BeRocket_product_new_filter', true );
        if( ! empty($filter_data) && ! empty($filter_post) ) {
            $filter_data['show_page'] = array();
            $filter_data['title'] = $filter_post->post_title;
            the_widget( 'BeRocket_AAPF_widget', $filter_data, $args);
        } else {
            return false;
        }
    }
    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['filter_id'] = strip_tags( @ $new_instance['filter_id'] );
        return $instance;
    }
    public function form($instance) {
        $instance = wp_parse_args( (array) $instance, array( 'filter_id' => '') );
        echo '<a href="' . admin_url('edit.php?post_type=br_product_filter') . '">' . __('Manage filters', 'BeRocket_AJAX_domain') . '</a>';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('filter_id'); ?>"><?php _e('Filter', 'BeRocket_AJAX_domain'); ?></label>
            <?php
            $query = new WP_Query(array('post_type' => 'br_product_filter', 'nopaging' => true));
            if ( $query->have_posts() ) {
                echo '<select id="'.$this->get_field_id('filter_id').'" name="'.$this->get_field_name('filter_id').'">';
                while ( $query->have_posts() ) {
                    if( empty($instance['filter_id']) ) {
                        $instance['filter_id'] = get_the_id();
                    }
                    $query->the_post();
                    echo '<option value="' . get_the_id() . '"'.(get_the_id() == $instance['filter_id'] ? ' selected' : '').'>' . get_the_title() . ' (ID:' . get_the_id() . ')</option>';
                }
                echo '</select>';
                wp_reset_postdata();
            }
            ?>
        </p>
        <?php
    }
}
?>
